<?php
// 管理画面のページ内容
function lmi_admin_page() {
    ?>
    <div class="wrap">
        <h1>Link Map Insights</h1>
        <div id="control-area">
            <label>
                <input type="checkbox" id="show-posts" name="show-posts" checked> 投稿を表示する
            </label>
            <label>
                <input type="checkbox" id="show-pages" name="show-pages" checked> 固定ページを表示する
            </label>
            <label>
                <input type="checkbox" id="toggle-title-length" name="toggle-title-length"> タイトルを省略する
            </label>
        </div>
        <div id="category-buttons">
            <button id="select-all-categories">全選択</button>
            <button id="deselect-all-categories">全解除</button>
        </div>
        <div id="category-filters"></div>
        <div id="search-area">
            <input type="text" id="node-search" placeholder="ノード検索">
            <button id="search-button">検索</button>
            <button id="reset-search-button">検索リセット</button>
        </div>
        <div id="zoom-controls">
            <button id="zoom-in">拡大</button>
            <button id="zoom-out">縮小</button>
        </div>
        <div id="network-container">
            <div id="mynetwork"></div>
            <div id="loadingBar">
                <div id="text">0%</div>
            </div>
        </div>
        <button id="generate-link-map">Generate</button>
        <h2 id="no-inbound-links-title">被リンクゼロのページ：0件</h2>
        <div id="no-inbound-links">
            <table id="no-inbound-links-table" class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>ページタイトル</th>
                        <th>編集</th>
                        <th>表示</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
        <h2 id="no-outbound-links-title">発リンクゼロのページ：0件</h2>
        <div id="no-outbound-links">
            <table id="no-outbound-links-table" class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>ページタイトル</th>
                        <th>編集</th>
                        <th>表示</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
    <?php
}

// 必要なスクリプトとスタイルの読み込み
function lmi_admin_enqueue_scripts($hook) {
    if ($hook !== 'toplevel_page_link-map-insights') {
        return;
    }
    wp_enqueue_script('vis-js', 'https://unpkg.com/vis-network@9.1.9/dist/vis-network.min.js', [], null, true);
    wp_enqueue_script('link-map-insights-admin-js', plugins_url('js/link-map-insights-admin.js', __FILE__), ['jquery', 'vis-js'], LMI_VERSION, true);
    wp_localize_script('link-map-insights-admin-js', 'lmiData', ['ajax_url' => admin_url('admin-ajax.php')]);
    wp_enqueue_style('link-map-insights-admin-css', plugins_url('css/link-map-insights-admin.css', __FILE__), [], LMI_VERSION);
}
add_action('admin_enqueue_scripts', 'lmi_admin_enqueue_scripts');
?>
