<?php

function lmi_get_dataset() {
    $post_types = isset($_POST['post_types']) ? $_POST['post_types'] : ['post', 'page'];

    $args = [
        'posts_per_page' => -1,
        'post_type' => $post_types,
        'post_status' => 'publish',
    ];
    $articles = get_posts($args);
    $nodes = [];
    $edges = [];
    $categories_colors = [];
    $parent_categories_colors = [];
    $no_inbound_links = [];
    $no_outbound_links = [];

    // 全親カテゴリーを取得
    $parent_categories = get_categories(['parent' => 0]);
    $total_parent_categories = count($parent_categories);

    // 各親カテゴリーに異なる色を割り当て（赤系統を除外）
    $hue_step = 360 / $total_parent_categories;
    $hue_start = 30; // 赤系統を避けて30度からスタート
    $hue_end = 330;  // 赤系統を避けて330度までを範囲とする
    $hue_range = $hue_end - $hue_start;

    foreach ($parent_categories as $index => $parent_category) {
        $hue = ($hue_start + ($index * $hue_step)) % 360;
        // 赤系統を避けるため、範囲を設定
        if ($hue < $hue_start || $hue > $hue_end) {
            $hue = ($hue_start + ($index * $hue_step)) % $hue_range + $hue_start;
        }

        $parent_categories_colors[$parent_category->term_id] = [
            'color' => sprintf('hsl(%d, 100%%, 70%%)', $hue), // 明度を70%に設定
            'name' => $parent_category->name
        ];
        // 親カテゴリーに属する子カテゴリーに明度を上げた色を適用
        $child_categories = get_categories(['parent' => $parent_category->term_id]);
        foreach ($child_categories as $child_category) {
            $child_color = preg_replace('/70%/', '85%', $parent_categories_colors[$parent_category->term_id]['color']);
            $parent_categories_colors[$child_category->term_id] = [
                'color' => $child_color,
                'name' => $child_category->name
            ];
        }
    }

    foreach ($articles as $post) {
        $categories = get_the_category($post->ID);
        $category_ids = wp_list_pluck($categories, 'term_id');

        $assigned_color = null;
        foreach ($category_ids as $category_id) {
            if (isset($parent_categories_colors[$category_id])) {
                $assigned_color = $parent_categories_colors[$category_id]['color'];
                break;
            }
        }

        if (!$assigned_color) {
            $assigned_color = sprintf('hsl(%d, 100%%, 85%%)', rand(0, 360));
        }

        foreach ($category_ids as $category_id) {
            $categories_colors[$category_id] = $assigned_color;
        }

        $nodes[] = [
            'id' => $post->ID,
            'label' => $post->post_title,
            'full_label' => $post->post_title,
            'short_label' => mb_strimwidth($post->post_title, 0, 40, '...'),
            'url' => get_permalink($post->ID),
            'post_type' => $post->post_type,
            'categories' => wp_list_pluck($categories, 'name'),
            'color' => $post->post_type === 'page' ? 'hsl(0, 0%, 0%)' : $assigned_color,
            'font' => ['color' => $post->post_type === 'page' ? '#FFFFFF' : '#000000'],
        ];

        $content = $post->post_content;

        // 既存のURLを取得
        preg_match_all('/(https?:\/\/[^\s"\'<>]+)/i', $content, $matches);
        $urls = array_unique($matches[1]); // 重複URLを排除

        // コメント内のlinkとidまたはpostIdからIDを取得（大文字・小文字を区別しない）
        preg_match_all('/<!--.*?(?:link).*?(?:id|postId).*?(\d+).*?-->/i', $content, $id_matches);
        $post_ids = array_unique($id_matches[1]); // 重複IDを排除

        // 投稿IDからURLを取得して$urlsに追加
        foreach ($post_ids as $post_id) {
            $post_url = get_permalink($post_id);
            if ($post_url) {
                $urls[] = $post_url;
            }
        }

        // 最終的なURLリストをユニーク化
        $urls = array_unique($urls);

        $has_outbound_link = false;
        foreach ($urls as $url) {
            $linked_post_id = url_to_postid($url);
            if ($linked_post_id && ($linked_post_id !== $post->ID)) { // 自己リンクを回避
                $edges[] = [
                    'from' => $post->ID,
                    'to' => $linked_post_id,
                ];
                $has_outbound_link = true;
            }
        }

        if (!$has_outbound_link) {
            $no_outbound_links[] = [
                'id' => $post->ID,
                'title' => $post->post_title,
                'edit_url' => get_edit_post_link($post->ID),
                'view_url' => get_permalink($post->ID)
            ];
        }
    }

    // Find reciprocal links and consolidate them
    $consolidated_edges = [];
    $added_edges = [];
    $inbound_links_count = [];

    foreach ($edges as $edge) {
        $reverse_edge = ['from' => $edge['to'], 'to' => $edge['from']];
        if (in_array($reverse_edge, $edges) && !in_array($reverse_edge, $added_edges)) {
            // Add the consolidated edge with arrows in both directions
            $consolidated_edges[] = ['from' => $edge['from'], 'to' => $edge['to'], 'arrows' => 'to, from'];
            $added_edges[] = $edge; // Mark the edge as added
            $added_edges[] = $reverse_edge; // Mark the reverse edge as added
        } elseif (!in_array($edge, $added_edges)) {
            $consolidated_edges[] = ['from' => $edge['from'], 'to' => $edge['to'], 'arrows' => 'to'];
        }

        if (!isset($inbound_links_count[$edge['to']])) {
            $inbound_links_count[$edge['to']] = 0;
        }
        $inbound_links_count[$edge['to']]++;
    }

    // 被リンクがゼロのページを検出
    foreach ($nodes as $node) {
        if (!isset($inbound_links_count[$node['id']])) {
            $no_inbound_links[] = [
                'id' => $node['id'],
                'title' => $node['label'],
                'edit_url' => get_edit_post_link($node['id']),
                'view_url' => get_permalink($node['id'])
            ];
        }
    }

    wp_send_json([
        'nodes' => $nodes,
        'edges' => $consolidated_edges,
        'categories_colors' => $parent_categories_colors,
        'no_inbound_links' => $no_inbound_links,
        'no_outbound_links' => $no_outbound_links
    ]);
}

add_action('wp_ajax_lmi_get_dataset', 'lmi_get_dataset');
add_action('wp_ajax_nopriv_lmi_get_dataset', 'lmi_get_dataset');
?>
